<?php

class Response
{
    /**
     * @var Identifier
     */
    private $identifier;
    /**
     * @var bool
     */
    private $result;
    private $timeStamp;
    private $description;
    private $hint;
    private $processor;
    private $code;

    /**
     * Get the value of identifier
     *
     * @return  Identifier
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * Set the value of identifier
     *
     * @param  Identifier  $identifier
     *
     * @return  self
     */
    public function setIdentifier(Identifier $identifier)
    {
        $this->identifier = $identifier;

        return $this;
    }

    public function setIdentifierbyObject($identifierObject)
    {
        $identifier = new Identifier();
        // String
        $identifier->setBatch($identifierObject->Batch->__toString());
        $identifier->setSerial($identifierObject->Serial->__toString());
        $identifier->setDocumentGUID($identifierObject->DocumentGUID->__toString());
        $identifier->setSuggestedFileName($identifierObject->SuggestedFileName->__toString());
        return $this->setIdentifier($identifier);
    }

    /**
     * Get the value of result
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * Set the value of result
     *
     * @return  self
     */
    public function setResult($result)
    {
        $this->result = (bool) $result;

        return $this;
    }

    /**
     * Get the value of timeStamp
     */
    public function getTimeStamp()
    {
        return $this->timeStamp;
    }

    /**
     * Set the value of timeStamp
     *
     * @return  self
     */
    public function setTimeStamp($timeStamp)
    {
        $this->timeStamp = $timeStamp;

        return $this;
    }

    /**
     * Get the value of description
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set the value of description
     *
     * @return  self
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the value of hint
     */
    public function getHint()
    {
        return $this->hint;
    }

    /**
     * Set the value of hint
     *
     * @return  self
     */
    public function setHint($hint)
    {
        $this->hint = $hint;

        return $this;
    }

    /**
     * Get the value of processor
     */
    public function getProcessor()
    {
        return $this->processor;
    }

    /**
     * Set the value of processor
     *
     * @return  self
     */
    public function setProcessor($processor)
    {
        $this->processor = $processor;

        return $this;
    }

    /**
     * Get the value of code
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set the value of code
     *
     * @return  self
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }
}
