<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require __DIR__ . '/../vendor/autoload.php';

final class ValidacionEstructuraXmlFelTest extends TestCase
{

    public function testRevisandoEstructuraXmlFel(): void
    {
        $validarXml = new ValidarXml();
        $validarXml->setEntradaXmlFromPath(__DIR__ . "/../archivos/test/fel_sat_ok.xml");
        $validarXml->setRutaXsd(ObtenerRutaArchivos::obtenerXsdDteFel());
        $this->assertEquals(
            true,
            $validarXml->ejecutar()
        );
    }

    public function testRevisandoEstructuraXmlFelIncorrecta(): void
    {
        $validarXml = new ValidarXml();
        $validarXml->setEntradaXmlFromPath(__DIR__ . "/../archivos/test/fel_sat_bad.xml");
        $validarXml->setRutaXsd(ObtenerRutaArchivos::obtenerXsdDteFel());
        $this->assertEquals(
            false,
            $validarXml->ejecutar()
        );
    }
}
