<?php

class ValidarXml
{
    private $entradaXml;

    private $rutaXsd;

    public function setRutaXsd($rutaXsd)
    {
        $this->rutaXsd = $rutaXsd;
    }

    public function setEntradaXmlFromString($entradaXmlString)
    {
        $this->entradaXml = $entradaXmlString;
    }

    public function setEntradaXmlFromPath($entradaXmlPath)
    {
        $rutaArchivo = realpath($entradaXmlPath);
        if ($rutaArchivo) {
            // Enable user error handling
            libxml_use_internal_errors(true);

            $xml = simplexml_load_file($rutaArchivo);
            $errors = libxml_get_errors();
            if ($errors) {
                RegistroLogs::getInstance()->error("setEntradaXmlFromPath::Errores encontrados al validar el XML.", $errors);
                // foreach ($errors as $error) {
                //     // TODO error handling
                //     print_r($error);
                // }
                libxml_clear_errors();
                return;
            }
            $this->setEntradaXmlFromString($xml->asXML());
        }
    }

    public function ejecutar()
    {
        // Enable user error handling
        libxml_use_internal_errors(true);

        $xml = new DOMDocument();
        if (!$xml->loadXML($this->entradaXml)) {
            $errors = libxml_get_errors();
            RegistroLogs::getInstance()->warning("ejecutar::Problema al cargar la informacion del xml de entrada.", $errors);
            libxml_clear_errors();
            return false;
        }
        // RegistroLogs::getInstance()->error("Objeto documento fel vacio.", ['nombre' => $this->felXmlFileName]);
        if (!$xml->schemaValidate($this->rutaXsd)) {
            $errors = libxml_get_errors();
            RegistroLogs::getInstance()->error("ejecutar::Errores encontrados al validar el XML.", $errors);
            // foreach ($errors as $error) {
            //     // TODO error handling
            //     print_r($error);
            // }
            libxml_clear_errors();
            return false;
        }
        return true;
    }
}
