<?php
date_default_timezone_set('America/Guatemala');
use Dotenv\Dotenv;
// use JsonMapper\JsonMapper;

require __DIR__ . '/vendor/autoload.php';

$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

include('./clases.php');

try {
    // get the HTTP method, path and body of the request
    $method = $_SERVER['REQUEST_METHOD'];
    // $request = explode('/', trim($_SERVER['PATH_INFO'], '/'));
    $input = json_decode(file_get_contents('php://input'), true);

    $datos_emisor = new DatosEmisor();

    // setting "emisor" data
    $datos_emisor->setAfiliacionIVA($input['emisor']['afiliacion']);
    $datos_emisor->setCodigoEstablecimiento($input['emisor']['cod_establecimiento']);
    $datos_emisor->setCodigoPostal($input['emisor']['cod_postal']);
    $datos_emisor->setCorreoEmisor($input['emisor']['correo']);
    $datos_emisor->setDepartamento($input['emisor']['departamento']);
    $datos_emisor->setMunicipio($input['emisor']['municipio']);
    $datos_emisor->setDireccion($input['emisor']['direccion']);
    $datos_emisor->setNITEmisor($input['emisor']['nit']);
    $datos_emisor->setNombreComercial($input['emisor']['nombre_com']);
    $datos_emisor->setNombreEmisor($input['emisor']['nombre_em']);
    $datos_emisor->setPais($input['emisor']['pais']);
    $datos_emisor->setRequestor($input['emisor']['requestor']);
    $datos_emisor->setUser($input['emisor']['user']);
    $datos_emisor->setUsername($input['emisor']['username']);

    $anulacionFel = new AnulacionFel();

    // setting "anulacion" data
    $anulacionFel->setNitEmisor($input['anulacion']['nitEmisor']);
    $anulacionFel->setIdReceptor($input['anulacion']['nitReceptor']);
    $anulacionFel->setNumeroDocumentoAnular($input['anulacion']['numeroDocumento']);
    $anulacionFel->setFechaEmisionDocumentoAnular($input['anulacion']['fechaHoraEmision']);
    $anulacionFel->setFechaHoraAnulacion(date('Y-m-d\TH:i:s'));
    $anulacionFel->setMotivoAnulacion($input['anulacion']['motivoAnulacion']);

    // Object to generate XML
    $generar_xml = new GenerarXml();
    // for certification
    $xmlData = $generar_xml->ToXml($anulacionFel);

    $requestTransaction = new RequestTransaction();
    $requestTransaction->setRequestor($datos_emisor->getRequestor());
    $requestTransaction->setTransaction('SYSTEM_REQUEST');
    $requestTransaction->setCountry($datos_emisor->getPais());
    $requestTransaction->setEntity($datos_emisor->getNitEmisor());
    $requestTransaction->setUser($datos_emisor->getUser());
    $requestTransaction->setUsername($datos_emisor->getUsername());
    $requestTransaction->setData1('VOID_DOCUMENT');
    $requestTransaction->setData2($xmlData->getXml());
    $requestTransaction->setData3('XML');
    
    $generarXmlG4s = new GenerarXmlG4s();
    $xmlG4s = $generarXmlG4s->requestTransactionToXmlbyString($requestTransaction);
    $firmarDocumentoG4s = new FirmarDocumentoG4s();
    $respuestaG4s = $firmarDocumentoG4s->ejecutar($xmlG4s);
    // RegistroLogs::getInstance()->error("respuestaG4s", ['respuestaG4s' => ($respuestaG4s)]);
    $objectResponse = array();
    if ($respuestaG4s["status"]) {
        $xmlResponse = simplexml_load_string($respuestaG4s["response"]);
        $content2 = str_replace(array_map(function ($e) {
            return "$e:";
        }, array_keys($xmlResponse->getDocNamespaces())), array(), $xmlResponse->asXML());
        $xmlParse = simplexml_load_string($content2);
        $requestTransactionResponse = new RequestTransactionResponse();
        $requestTransactionResponse->setRequestTransactionResultbyObject($xmlParse->Body->RequestTransactionResponse->RequestTransactionResult);
        $requestTransactionResult = $requestTransactionResponse->getRequestTransactionResult();
        $response = $requestTransactionResult ? $requestTransactionResult->getResponse() : null;
        if ($response) {
            $result = $response->getResult();
            $description = $response->getDescription();
            $code = $response->getCode();
            $objectResponse["resultado"] = $result;
            $objectResponse["descripcion"] = $description;
            $objectResponse["codigoResultado"] = $code;
            if($result) {
                $objectResponse["mensaje"] = "Documento anulado correctamente.";
            }
            else {
                $objectResponse["mensaje"] = "Error al generar el documento.";
            }
        }
    }

    header('Content-Type: application/json');
    echo json_encode($objectResponse);

} catch (Exception $e) {
    echo 'Excepción capturada: ',  $e->getMessage(), "\n";
}
