<?php

use Dotenv\Dotenv;

require __DIR__ . '/vendor/autoload.php';

$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

include('./clases.php');

$objectResponse = array();

try {
    $numero_autorizacion = isset($_GET['numero_autorizacion']) ? $_GET['numero_autorizacion'] : null;
    $nit = isset($_GET['nit_receptor']) ? $_GET['nit_receptor'] : null;

    try {
        // Almacenar en base de datos
        $servername = $_ENV['DB_HOST'] . ':' . $_ENV['DB_PORT'];
        $username = $_ENV['DB_USERNAME'];
        $password = $_ENV['DB_PASSWORD'];
        $database_name = $_ENV['DB_DATABASE'];

        // Create connection
        $conn = mysqli_connect($servername, $username, $password, $database_name);
        
        // Check connection
        if (!$conn) {
            RegistroLogs::getInstance()->info("Connection failed: " . mysqli_connect_error(), array());
        } else {
            RegistroLogs::getInstance()->info("Connected successfully", array());
        }
        
        $sql = "SELECT `bitacora_fel`.`idbitacora_fel`,
            `bitacora_fel`.`nit_receptor_fel`,
            `bitacora_fel`.`nit_emisor_fel`,
            `bitacora_fel`.`numero_autorizacion_fel`,
            `bitacora_fel`.`numero_serie_fel`,
            `bitacora_fel`.`numero_documento_fel`,
            `bitacora_fel`.`detalle_factura_fel`,
            `bitacora_fel`.`fecha_creacion_fel`
        FROM `". $database_name ."`.`bitacora_fel`
        WHERE `bitacora_fel`.`nit_receptor_fel` = \"" . $nit . "\" and `bitacora_fel`.`numero_autorizacion_fel` = \"" . $numero_autorizacion ."\";";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            // RegistroLogs::getInstance()->info("Encontrado.", array());
          // output data of each row
            $row = $result->fetch_assoc();
            $documentoFelBase64Decode = base64_decode($row["detalle_factura_fel"]);
            $documentoFel = unserialize($documentoFelBase64Decode);
                
            // GENERAR HTML
            $generarHtml = new GenerarHTML();
            $generarHtml->setNombreEmpresaEmisor($documentoFel->getDatosEmisor()->getNombreEmisor());
            $generarHtml->setNitEmisor($documentoFel->getDatosEmisor()->getNitEmisor());
            $generarHtml->setNombreComercialEmisor($documentoFel->getDatosEmisor()->getNombreComercial());
            $generarHtml->setDireccionEmisor($documentoFel->getDatosEmisor()->getDireccion());
            $generarHtml->setNumeroAutorizacion($row["numero_autorizacion_fel"]);
            $generarHtml->setNumeroSerie($row["numero_serie_fel"]);
            $generarHtml->setNumeroDocumento($row["numero_documento_fel"]);
            $generarHtml->setFechaHoraEmision($documentoFel->getDatosGenerales()->getFechaHoraEmision());
            $generarHtml->setFechaEmision($documentoFel->getDatosGenerales()->getFechaEmision());
            $generarHtml->setNitReceptor($documentoFel->getDatosReceptor()->getIdReceptor());
            $generarHtml->setNombreReceptor($documentoFel->getDatosReceptor()->getNombreReceptor());
            $generarHtml->setDireccionReceptor($documentoFel->getDatosReceptor()->getDireccion());
            $generarHtml->setItems($documentoFel->getItems());
            $generarHtml->setTotal($documentoFel->getTotales()->getGranTotal());
            $generarHtml->setDescuento($documentoFel->getDescuentos());

            
            $objectResponse["result"] = true;
            $objectResponse["mensaje"] = "Invoice successfully generated.";
            $objectResponse["htmlTemplate"] = $generarHtml->generarPlantillaHTML('archivos/template_ticket.latte');
            $objectResponse["emailhtmlTemplate"] = $generarHtml->generarPlantillaHTML('archivos/template_letter.latte');

            header('Content-Type: application/json');
            echo json_encode($objectResponse);
        } else {
            $objectResponse["result"] = false;
            $objectResponse["mensaje"] = "No results were found for the requested information.";

            header('Content-Type: application/json');
            echo json_encode($objectResponse);
        }
          
        $conn->close();
    } catch (Exception $e) {
        RegistroLogs::getInstance()->info("Error", array());
        $objectResponse["result"] = false;
        $objectResponse["mensaje"] = $e->getMessage();
            
        header('Content-Type: application/json');
        echo json_encode($objectResponse);
    }
} catch (Exception $e) {
    $objectResponse["result"] = false;
    $objectResponse["mensaje"] = "The request could not be completed.";
            
    header('Content-Type: application/json');
    echo json_encode($objectResponse);
}