<?php

use Dotenv\Dotenv;

require __DIR__ . '/vendor/autoload.php';

$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->load();

include('./clases.php');

try {
    $request = isset($_SERVER['PATH_INFO']) ? explode('/', trim($_SERVER['PATH_INFO'], '/')) : null;
    if($request) {
        if(is_array($request) && count($request) == 2) {
            $action = $request[0];
            switch ($action) {
                case 'validar':
                    $validarNIT = new ValidarNIT();
                    $respuestaValidacionNIT = $validarNIT->ejecutar($request[1]);
                    
                    header('Access-Control-Allow-Origin: *');
                    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
                    header("Access-Control-Allow-Methods: GET, OPTIONS");
                    header("Allow: GET, OPTIONS");
                    header('Content-Type: application/json');
                    echo json_encode($respuestaValidacionNIT);
                    break;
                
                default:
                    # code...
                    break;
            }
        }
    }
} catch (Exception $e) {
    echo 'Excepción capturada: ',  $e->getMessage(), "\n";
}