<?php

class ObjetoG4s
{

    /**
     * @var RequestTransactionResult
     */
    private RequestTransactionResult $requestTransactionResult;
    

    /**
     * @var RequestTransaction
     */
    private RequestTransaction $requestTransaction;

    /**
     * @var RequestTransaction
     */
    private DocumentoFel $documentoFel;

    // /**
    //  * Get the value of requestTransactionResult
    //  *
    //  * @return  RequestTransactionResult
    //  */ 
    // public function getRequestTransactionResult()
    // {
    //     return $this->requestTransactionResult;
    // }

    /**
     * Set the value of requestTransactionResult
     *
     * @param  RequestTransactionResult  $requestTransactionResult
     *
     * @return  self
     */
    public function setRequestTransactionResult(RequestTransactionResult $requestTransactionResult)
    {
        $this->requestTransactionResult = $requestTransactionResult;

        return $this;
    }

    /**
     * Set the value of requestTransaction
     *
     * @param  RequestTransaction  $requestTransaction
     *
     * @return  self
     */ 
    public function setRequestTransaction(RequestTransaction $requestTransaction)
    {
        $this->requestTransaction = $requestTransaction;

        return $this;
    }

    
    /**
     * Set the value of requestTransaction
     *
     * @param  DocumentoFel  $documentoFel
     *
     * @return  self
     */ 
    public function setDocumentoFel(DocumentoFel $documentoFel)
    {
        $this->documentoFel = $documentoFel;
        return $this;
    }

    public function ejecutar()
    {
        $objectResponse = array();
        $response = $this->requestTransactionResult ? $this->requestTransactionResult->getResponse() : null;
        if ($response) {
            $result = $response->getResult();
            $description = $response->getDescription();
            $code = $response->getCode();
            // TODO result is null
            $objectResponse["resultado"] = $result;
            $objectResponse["descripcion"] = $description;
            $objectResponse["codigoResultado"] = $code;
            if ($result) {
                // Identifier contiene el Número de Autorización, Serie y Número del DTE
                $identifier = $response->getIdentifier();
                // Numero de Serie
                $batch = $identifier ? $identifier->getBatch() : null;
                // Numero de Documento
                $serial = $identifier ? $identifier->getSerial() : null;
                // Numero de Autorización
                $documentGUID = $identifier ? $identifier->getDocumentGUID() : null;
                // Nombre de archivo sugerido por G4S
                $fileName = $identifier ? $identifier->getSuggestedFileName() : null;

                // Preparacion de objeto de respuesta
                $objectResponse["numeroSerie"] = $batch;
                $objectResponse["numeroDocumento"] = $serial;
                $objectResponse["numeroAutorizacion"] = $documentGUID;
                $objectResponse["nombreArchivo"] = $fileName;
                $objectResponse["mensaje"] = "Documento generado correctamente.";
                $objectResponse["fechaHoraEmision"] = $this->documentoFel->getDatosGenerales()->getFechaHoraEmision();

                try {
                    // Almacenar en base de datos
                    $servername = $_ENV['DB_HOST'] . ':' . $_ENV['DB_PORT'];
                    $username = $_ENV['DB_USERNAME'];
                    $password = $_ENV['DB_PASSWORD'];
                    $database_name = $_ENV['DB_DATABASE'];
    
                    // Data
                    $fechaHoraEmision = date_format(date_create($objectResponse["fechaHoraEmision"]), "Y/m/d H:i:s");
    
                    // Create connection
                    $conn = mysqli_connect($servername, $username, $password, $database_name);
                    
                    // Check connection
                    if (!$conn) {
                        RegistroLogs::getInstance()->info("Connection failed: " . mysqli_connect_error(), array());
                    } else {
                        RegistroLogs::getInstance()->info("Connected successfully", array());
                    }
    
                    $sql = "INSERT INTO `". $database_name ."`.`bitacora_fel` (`nit_receptor_fel`, `nit_emisor_fel`, `numero_autorizacion_fel`, `numero_serie_fel`, `numero_documento_fel`, `detalle_factura_fel`, `fecha_creacion_fel`)" . 
                    " VALUES (\"" . $this->documentoFel->getDatosReceptor()->getIdReceptor() . "\", \""  . $this->documentoFel->getDatosEmisor()->getNitEmisor() . "\", \""
                    . $objectResponse["numeroAutorizacion"] . "\", \"" . $objectResponse["numeroSerie"] . "\", \"" . $objectResponse["numeroDocumento"] . "\", \"" 
                    . base64_encode(serialize($this->documentoFel)) . "\", \"" . $fechaHoraEmision. "\");";
    
                    if ($conn->query($sql) === TRUE) {
                        RegistroLogs::getInstance()->info($objectResponse["numeroAutorizacion"] . " recorded successfully.", array());
                    } else {
                        RegistroLogs::getInstance()->error($objectResponse["numeroAutorizacion"] . " Error: " . $sql . "<br>" . $conn->error, array());
                    }
                      
                    $conn->close();
                } catch (\Throwable $th) {
                    //throw $th;
                }
                
                // GENERAR HTML
                $generarHtml = new GenerarHTML();
                $generarHtml->setNombreEmpresaEmisor($this->documentoFel->getDatosEmisor()->getNombreEmisor());
                $generarHtml->setNitEmisor($this->documentoFel->getDatosEmisor()->getNitEmisor());
                $generarHtml->setNombreComercialEmisor($this->documentoFel->getDatosEmisor()->getNombreComercial());
                $generarHtml->setDireccionEmisor($this->documentoFel->getDatosEmisor()->getDireccion());
                $generarHtml->setNumeroAutorizacion($documentGUID);
                $generarHtml->setNumeroSerie($batch);
                $generarHtml->setNumeroDocumento($serial);
                $generarHtml->setFechaHoraEmision($this->documentoFel->getDatosGenerales()->getFechaHoraEmision());
                $generarHtml->setFechaEmision($this->documentoFel->getDatosGenerales()->getFechaEmision());
                $generarHtml->setNitReceptor($this->documentoFel->getDatosReceptor()->getIdReceptor());
                $generarHtml->setNombreReceptor($this->documentoFel->getDatosReceptor()->getNombreReceptor());
                $generarHtml->setDireccionReceptor($this->documentoFel->getDatosReceptor()->getDireccion());
                $generarHtml->setItems($this->documentoFel->getItems());
                $generarHtml->setTotal($this->documentoFel->getTotales()->getGranTotal());
                $generarHtml->setDescuento($this->documentoFel->getDescuentos());
                $objectResponse["htmlTemplate"] = $generarHtml->generarPlantillaHTML('archivos/template_ticket.latte');
                $objectResponse["emailhtmlTemplate"] = $generarHtml->generarPlantillaHTML('archivos/template_letter.latte');
                // $myfile = fopen("facturaEmail.html", "w") or die("Unable to open file!");
                // $txt = $objectResponse["emailhtmlTemplate"];
                // fwrite($myfile, $txt);
                // fclose($myfile);
            } else {
                $objectResponse["mensaje"] = "Error al generar el documento.";
            }
            return json_encode($objectResponse);
        }
        return null;
    }
}
