<?php

class ObjetoG4s
{

    /**
     * @var RequestTransactionResult
     */
    private RequestTransactionResult $requestTransactionResult;

    // /**
    //  * Get the value of requestTransactionResult
    //  *
    //  * @return  RequestTransactionResult
    //  */ 
    // public function getRequestTransactionResult()
    // {
    //     return $this->requestTransactionResult;
    // }

    /**
     * Set the value of requestTransactionResult
     *
     * @param  RequestTransactionResult  $requestTransactionResult
     *
     * @return  self
     */
    public function setRequestTransactionResult(RequestTransactionResult $requestTransactionResult)
    {
        $this->requestTransactionResult = $requestTransactionResult;

        return $this;
    }

    public function ejecutar()
    {
        $objectResponse = array();
        $response = $this->requestTransactionResult ? $this->requestTransactionResult->getResponse() : null;
        if ($response) {
            $result = $response->getResult();
            $description = $response->getDescription();
            $code = $response->getCode();
            // TODO result is null
            $objectResponse["resultado"] = $result;
            $objectResponse["descripcion"] = $description;
            $objectResponse["codigoResultado"] = $code;
            if ($result) {
                $identifier = $response->getIdentifier();
                $batch = $identifier ? $identifier->getBatch() : null;
                $serial = $identifier ? $identifier->getSerial() : null;
                $documentGUID = $identifier ? $identifier->getDocumentGUID() : null;
                $objectResponse["numeroSerie"] = $batch;
                $objectResponse["numeroDocumento"] = $serial;
                $objectResponse["numeroAutorizacion"] = $documentGUID;
                $objectResponse["mensaje"] = "Documento generado correctamente.";
            } else {
                $objectResponse["mensaje"] = "Error al generar el documento.";
            }
            return json_encode($objectResponse);
        }
        return null;
    }
}
