<?php

class GenerarXmlG4s
{
    public function requestTransactionToXml($requestTransaction)
    {
        $url = "https://pruebasfel.g4sdocumenta.com/webservicefront/factwsfront.asmx?WSDL";
        $path = "file://" . __DIR__ . "/../archivos/g4s-fel.wsdl";
        $client = new SoapClient($path, array(
            "trace" => 1,
            "exception" => 0,
            "wsdl_cache" => WSDL_CACHE_MEMORY,
            "location" => $url
        ));

        $soapstruct = new SoapVar($requestTransaction, SOAP_ENC_OBJECT);

        $RequestTransactionParam = new SoapParam($soapstruct, "RequestTransaction");

        $client->RequestTransaction($RequestTransactionParam);

        return $client->__getLastRequest();
        // Print WS response
        // var_dump($response);
        // var_dump($xml);
    }

    public function requestTransactionToXmlbyString(RequestTransaction $requestTransaction)
    {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ws=\"http://www.fact.com.mx/schema/ws\">\n"
            . "<soapenv:Header/>\n"
            . "<soapenv:Body>\n"
            . "<ws:RequestTransaction>\n"

            . "<ws:Requestor>" . $requestTransaction->getRequestor() . "</ws:Requestor>\n"

            . "<ws:Transaction>" . $requestTransaction->getTransaction() . "</ws:Transaction>\n"

            . "<ws:Country>" . $requestTransaction->getCountry() . "</ws:Country>\n"

            . "<ws:Entity>" . $requestTransaction->getEntity() . "</ws:Entity>\n"

            . "<ws:User>" . $requestTransaction->getUser() . "</ws:User>\n"

            . "<ws:UserName>" . $requestTransaction->getUsername() . "</ws:UserName>\n"

            . "<ws:Data1>" . $requestTransaction->getData1() . "</ws:Data1>\n"

            . "<ws:Data2>" . $requestTransaction->getData2() . "</ws:Data2>\n"

            . "<ws:Data3>" . $requestTransaction->getData3() . "</ws:Data3>\n"

            . "</ws:RequestTransaction>\n"
            . "</soapenv:Body>\n"
            . "</soapenv:Envelope>\n";
    }
}
