<?php

use HTTP\Request2;

class ValidarNIT
{

    private $request;

    public  function __construct()
    {
        $request = new HTTP_Request2();
        $request->setUrl($_ENV["G4S_URL_VALIDAR_NIT"] . '?wsdl');
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(array(
            'follow_redirects' => TRUE
        ));
        $request->setHeader(array(
            'Content-Type: text/xml',
        ));
        $this->request = $request;
    }

    private function generarXMLResquestValidacionNIT($nit) {
        return "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tem=\"http://tempuri.org/\">\n"
                . "<soapenv:Header/>\n"
                .   "<soapenv:Body>\n"
                .       "<tem:getNIT>\n"
                .           "<tem:vNIT>" . $nit . "</tem:vNIT>\n"
                .           "<tem:Entity>" . $_ENV['FEL_EMISOR'] . "</tem:Entity>\n"
                .           "<tem:Requestor>" . $_ENV['FEL_REQUESTOR'] . "</tem:Requestor>\n"
                .           "</tem:getNIT>\n"
                .   "</soapenv:Body>\n"
                ."</soapenv:Envelope>\n";
    }

    private function ejecutarServicioValidacionNIT($xmlBody)
    {
        $result = array();
        try {
            $this->request->setBody($xmlBody);
            $response = $this->request->send();
            if ($response->getStatus() == 200) {
                $result["response"] = $response->getBody();
                $result["status"] = true;
            } else {
                $result["response"] = 'Unexpected HTTP status: ' . $response->getStatus() . ' ' .
                    $response->getReasonPhrase();
                $result["status"] = false;
            }
        } catch (HTTP_Request2_Exception $e) {
            $result["response"] = 'Error: ' . $e->getMessage();
            $result["status"] = false;
        }
        return $result;
    }

    private function formatearRespuestaServicioValidacionNIT($resultRequest) {
        $respuestaServicioValidacionNIT = array();
        if ($resultRequest["status"]) {
            $xmlResponse = simplexml_load_string($resultRequest["response"]);
            $content2 = str_replace(array_map(function ($e) {
                return "$e:";
            }, array_keys($xmlResponse->getDocNamespaces())), array(), $xmlResponse->asXML());
            $xmlParse = simplexml_load_string($content2);
            $getNITResponse = null;
            try {
                $getNITResponse = $xmlParse->Body->getNITResponse->getNITResult->Response;
            } catch (\Throwable $th) {
                //throw $th;
            }
            if($getNITResponse) {
                $respuestaServicioValidacionNIT["estado"] = $getNITResponse->Result->__toString();
                $respuestaServicioValidacionNIT["nit"] = $getNITResponse->NIT->__toString();
                $respuestaServicioValidacionNIT["nombre"] = $this->formatearNombre($getNITResponse->nombre->__toString());
                $respuestaServicioValidacionNIT["error"] = $getNITResponse->error->__toString();
            }
        }
        return $respuestaServicioValidacionNIT; 
    }

    private function formatearNombre($nombre) {
        if($nombre) {
            $data = array();
            $nombres = array_reverse(explode(",,", html_entity_decode($nombre)));
            for ($i=0; $i < count($nombres); $i++) { 
                array_push($data, implode(" ",explode(",",$nombres[$i])));
            }
            // return implode(" ",$data);
            return array('nombreRegistrado' => $data[0], 'apellidoRegistrado' => isset($data[1]) ? $data[1] : null, 'nombreCompletoRegistrado' => implode(" ",$data));
        }
        return $nombre;
    }

    public function ejecutar($nit) {
        $xmlRequest = $this->generarXMLResquestValidacionNIT($nit);
        $resultRequest = $this->ejecutarServicioValidacionNIT($xmlRequest);
        return $this->formatearRespuestaServicioValidacionNIT($resultRequest);
    }
}
