<?php
$relativePathPosition = '/..';
$pathRootFolder = __DIR__ . $relativePathPosition;

require $pathRootFolder . '/vendor/autoload.php';

class GenerarHTML
{
    private $nombreEmpresaEmisor;
    
    private $nitEmisor;

    private $nombreComercialEmisor;

    private $direccionEmisor;
    
    private $municipioEmisor;

    private $departamentoEmisor;

    private $numeroAutorizacion;

    private $numeroSerie;

    private $numeroDocumento;

    private $fechaHoraEmision;

    private $fechaEmision;

    private $nitReceptor;

    private $nombreReceptor;

    private $direccionReceptor;

    private $items;

    private $total;

    private $descuento;

    public function setNombreEmpresaEmisor($nombreEmpresaEmisor)
    {
        $this->nombreEmpresaEmisor = $nombreEmpresaEmisor;
    }

    public function setNitEmisor($nitEmisor)
    {
        $this->nitEmisor = $nitEmisor;
    }

    public function setNombreComercialEmisor($nombreComercialEmisor)
    {
        $this->nombreComercialEmisor = $nombreComercialEmisor;
    }

    public function setDireccionEmisor($direccionEmisor)
    {
        $this->direccionEmisor = $direccionEmisor;
    }
    
    public function setMunicipioEmisor($municipioEmisor)
    {
        $this->municipioEmisor = $municipioEmisor;
    }

    public function setDepartamentoEmisor($departamentoEmisor)
    {
        $this->departamentoEmisor = $departamentoEmisor;
    }

    public function setNumeroAutorizacion($numeroAutorizacion)
    {
        $this->numeroAutorizacion = $numeroAutorizacion;
    }

    public function setNumeroSerie($numeroSerie)
    {
        $this->numeroSerie = $numeroSerie;
    }

    public function setNumeroDocumento($numeroDocumento)
    {
        $this->numeroDocumento = $numeroDocumento;
    }

    public function setFechaHoraEmision($fechaHoraEmision)
    {
        $this->fechaHoraEmision = $fechaHoraEmision;
    }

    public function setFechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
    }

    public function setNitReceptor($nitReceptor)
    {
        $this->nitReceptor = $nitReceptor;
    }

    public function setNombreReceptor($nombreReceptor)
    {
        $this->nombreReceptor = $nombreReceptor;
    }

    public function setDireccionReceptor($direccionReceptor)
    {
        $this->direccionReceptor = $direccionReceptor;
    }

    public function setItems($items)
    {
        $this->items = $items;
    }

    public function setTotal($total)
    {
        $this->total = $total;
    }

    public function setDescuento($descuento)
    {
        $this->descuento = $descuento;
    }

    public function generarPlantillaHTML($template)
    {
        $latte = new Latte\Engine;
        $fecha = strtotime($this->fechaHoraEmision);
        $facturaDatos = array(
            'nombreEmpresa' => $this->nombreEmpresaEmisor,
            'nit' => $this->nitEmisor,
            'nombre' => $this->nombreComercialEmisor,
            'direccion' => $this->direccionEmisor,
            'municipio' => $this->municipioEmisor,
            'departamento' => $this->departamentoEmisor,
            'numeroAutorizacion' => $this->numeroAutorizacion,
            'serie' => $this->numeroSerie,
            'no' => $this->numeroDocumento,
            'fecha' => date('Y-m-d',$fecha),
            'nitCliente' => $this->nitReceptor,
            'nombreCliente' => $this->nombreReceptor,
            'direccionCliente' => $this->direccionReceptor,
            'productos' => $this->items,
            'total' => $this->total,
            'descuento' => $this->descuento,
            'fechaCertificacion' => $this->fechaHoraEmision,
            'certificadorNombre' => 'G4S DOCUMENTA, S.A.',
            'certificadorNit' => 'NIT: 60010207'        
        );
        // RegistroLogs::getInstance()->info("respuestaValidacionNIT", ['respuestaValidacionNIT' => json_encode($facturaDatos)]);
        $html = $latte->renderToString($template, $facturaDatos);
        return $html;

    }
}