<?php

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

require __DIR__ . '/../vendor/autoload.php';

final class ObtenerRutaArchivosTest extends TestCase
{
    
    public function testRutaArchivoXsdFelExiste(): void
    {
        $this->assertIsString(ObtenerRutaArchivos::obtenerXsdDteFel());
    }

    public function testArchivoXsdFelExiste(): void
    {
        $this->assertFileExists(ObtenerRutaArchivos::obtenerXsdDteFel());
    }
}
