<?php

use HTTP\Request2;

class FirmarDocumentoG4s
{

    private $request;

    public  function __construct()
    {
        $request = new HTTP_Request2();
        $request->setUrl('https://pruebasfel.g4sdocumenta.com/webservicefront/factwsfront.asmx?wsdl');
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(array(
            'follow_redirects' => TRUE
        ));
        $request->setHeader(array(
            'Content-Type: text/xml',
        ));
        $this->request = $request;
    }

    public function ejecutar($xmlBody)
    {
        $result = array();
        try {
            $this->request->setBody($xmlBody);
            $response = $this->request->send();
            if ($response->getStatus() == 200) {
                $result["response"] = $response->getBody();
                $result["status"] = true;
            } else {
                $result["response"] = 'Unexpected HTTP status: ' . $response->getStatus() . ' ' .
                    $response->getReasonPhrase();
                $result["status"] = false;
            }
        } catch (HTTP_Request2_Exception $e) {
            $result["response"] = 'Error: ' . $e->getMessage();
            $result["status"] = false;
        }
        return $result;
    }
}
