<?php

use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Monolog\Formatter\JsonFormatter;

class RegistroLogs
{
    private static $instance;
    private static $logger;

    private function __construct()
    {
        self::$logger = new Logger('fel_logger');
        // Now add some handlers
        $handler = new RotatingFileHandler(__DIR__ . '/../../logs/g4s_fel.log', 7, Logger::INFO);
        $handler->setFormatter(new JsonFormatter(1, true, true));
        self::$logger->pushHandler($handler);
    }

    public static function getInstance()
    {
        if (!self::$instance instanceof self) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function info($mensaje, $data)
    {
        self::$logger->info($mensaje, $data);
    }

    public function error($mensaje, $data)
    {
        self::$logger->error($mensaje, $data);
    }

    public function debug($mensaje, $data)
    {
        self::$logger->debug($mensaje, $data);
    }

    public function warning($mensaje, $data)
    {
        self::$logger->warning($mensaje, $data);
    }

    public function log($level, $mensaje, $data)
    {
        self::$logger->info($mensaje, $data);
    }
}
